; The CMD file.
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional)
;   buffer.time = time (optional)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas. Each of these
;   buttons or directions is referred to as a "symbol".
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /DB, a   ;hold down-back while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   greater-than (>) - means there must be no other keys pressed or released
;                      between the previous and the current symbol.
;          egs. command = a, >~a   ;press a and release it without having hit
;                                  ;or released any other keys in between
;   You can combine the symbols:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;
;   Note: Successive direction symbols are always expanded in a manner similar
;         to this example:
;           command = F, F
;         is expanded when MUGEN reads it, to become equivalent to:
;           command = F, >~F, >F
;
;   It is recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This makes the command easier
;   to do.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. The default
;   value for this is set in the [Defaults] section below. A typical
;   value is 15.
;
; - buffer.time (optional)
;   Time that the command will be buffered for. If the command is done
;   successfully, then it will be valid for this time. The simplest
;   case is to set this to 1. That means that the command is valid
;   only in the same tick it is performed. With a higher value, such
;   as 3 or 4, you can get a "looser" feel to the command. The result
;   is that combos can become easier to do because you can perform
;   the command early. Attacks just as you regain control (eg. from
;   getting up) also become easier to do. The side effect of this is
;   that the command is continuously asserted, so it will seem as if
;   you had performed the move rapidly in succession during the valid
;   time. To understand this, try setting buffer.time to 30 and hit
;   a fast attack, such as KFM's light punch.
;   The default value for this is set in the [Defaults] section below. 
;   This parameter does not affect hold-only commands (eg. /F). It
;   will be assumed to be 1 for those commands.
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands examples are given below.
;
; [Command] ;Quarter circle forward + x
; name = "QCF_x"
; command = ~D, DF, F, x
;
; [Command] ;Half circle back + a
; name = "HCB_a"
; command = ~F, DF, D, DB, B, a
;
; [Command] ;Two quarter circles forward + y
; name = "2QCF_y"
; command = ~D, DF, F, D, DF, F, y
;
; [Command] ;Tap b rapidly
; name = "5b"
; command = b, b, b, b, b
; time = 30
;
; [Command] ;Charge back, then forward + z
; name = "charge_B_F_z"
; command = ~60$B, F, z
; time = 10
;
; [Command] ;Charge down, then up + c
; name = "charge_D_U_c"
; command = ~60$D, U, c
; time = 10


;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------

[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1

;--|AI Activation|----------------------------------------------------------

[Command]
name = "AI1"
command = U,U,U,U,F,B,B,F,a,b,a,c,a,b
time = 1

[Command]
name = "AI2"
command = U,U,U,D,F,B,B,F,b,a,a,a,a,a,a
time = 1

[Command]
name = "AI3"
command = U,U,D,D,F,B,B,F,c,c,c,c,c,c,c
time = 1

[Command]
name = "AI4"
command = U,D,D,D,F,B,B,F,x,b,b,b,
time = 1

[Command]
name = "AI5"
command = D,D,D,D,F,B,B,F,y,a,a,c,b
time = 1

[Command]
name = "AI6"
command = D,D,D,U,F,B,B,F,z,z,z,z,z,x,a
time = 1

[Command]
name = "AI7"
command = D,D,U,U,F,B,B,F,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x,x
time = 1

[Command]
name = "AI8"
command = D,U,U,U,F,B,B,F,z,z,z,z,z,z,z,x,x,x,x,x
time = 1

[Command]
name = "AI9"
command = U,D,U,U,F,B,B,F,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,a,a,a,a,a,a,a
time = 1

[Command]
name = "AI10"
command = U,U,D,U,F,B,B,F,c,c,c,c,c,a,a,a,z,z,z,x,x,x,x
time = 1

[Command]
name = "AI11"
command = D,U,U,D,F,B,B,F,b,b,b,b,b,b,B,B,B,B,B,B,B,B,B,B,B,
time = 1

[Command]
name = "AI12"
command = U,D,D,U,F,B,B,F,D,D,D,D,D,D,D,D,D,D,D,D,
time = 1

[Command]
name = "AI13"
command = D,U,D,U,F,B,B,F,U,U,U,U,U,U,U,U,U,U,U,U,U,D
time = 1

[Command]
name = "AI14"
command = U,D,U,D,F,B,B,F,B,B,B,B,B,B,B,B,B,B,B,B,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z
time = 1

[Command]
name = "AI15"
command = F,F,F,F,F,B,B,F,D,D,D,D,D,D,D,x,x,x,x,x,x,x,x,z,z,z,z,z
time = 1

[Command]
name = "AI16"
command = B,B,B,B,F,B,B,F,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z,a,b,c,x,y,z
time = 1

[Command]
name = "AI17"
command = F,B,F,F,F,B,B,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,U,U,U,U,U,U,U,U,U,U,U,U,F
time = 1

[Command]
name = "AI18"
command = F,F,B,F,F,B,B,F,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B
time = 1

[Command]
name = "AI19"
command = B,F,F,F,F,B,B,F,F,F,F,F,F,F,F,F,F,F,F,F,U,U,U,U,U,U,U,U,U,U,U,U,U,D,D,D,D,D,D,D,B,B,B
time = 1

[Command]
name = "AI20"
command = F,F,F,B,F,B,B,F,F,F,F,B,F,B,B,F,F,F,F,B,F,B,B,F,F,F,F,B,F,B,B,F,F,F,F,B,F,B,B,F,F,F,F,B,F,B,B,F
time = 1

[Command]
name = "AI21"
command = F,B,B,F,F,B,B,F,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B,D,B
time = 1

[Command]
name = "AI22"
command = B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F,B,F,F,B,F,B,B,F
time = 1

[Command]
name = "AI23"
command = F,B,F,B,F,B,B,F,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B,B
time = 1

[Command]
name = "AI24"
command = B,F,B,F,F,B,B,F,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z,x,y,z
time = 1

[Command]
name = "AI25"
command = D,F,D,F,F,B,B,F
time = 1

[Command]
name = "AI26"
command = D,B,D,B,F,B,B,F
time = 1

[Command]
name = "AI27"
command = D,B,D,F,F,B,B,F
time = 1

[Command]
name = "AI28"
command = D,F,D,B,F,B,B,F
time = 1

[Command]
name = "AI29"
command = U,F,D,B,F,B,B,F
time = 1

[Command]
name = "AI30"
command = U,B,D,F,F,B,B,F
time = 1

;-| Super Motions |--------------------------------------------------------

[Command]
name = "Onslaught"
command = ~D, DF, F, x
time = 20

;-| Special Motions |------------------------------------------------------

[Command]
name = "Axe Hand Projectile"
command = z
time = 20

[Command]
name = "Call Marine Sword"
command = a
time = 20

[Command]
name = "Call Marine Shotgun"
command = b
time = 20

[Command]
name = "Counter"
command = z
time = 20

[Command]
name = "Counter"
command = x
time = 20

[Command]
name = "Counter"
command = y
time = 20

;-| Double Tap |-----------------------------------------------------------

[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 10

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------

[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

[Command]
name = "recovery";Required (do not remove)
command = y+z
time = 1

[Command]
name = "recovery";Required (do not remove)
command = z+a
time = 1

[Command]
name = "recovery";Required (do not remove)
command = a+b
time = 1

[Command]
name = "recovery";Required (do not remove)
command = b+c
time = 1

[Command]
name = "recovery";Required (do not remove)
command = c+z
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

[Command]
name = "holda";Required (do not remove)
command = /$a
time = 1

;---------------------------------------------------------------------------
; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]
;---------------------------------------------------------------------------
;Onslaught (uses one super bar)
[State -1, Onslaught]
type = ChangeState
value = 3000
triggerall = command = "Onslaught"
triggerall = power >= 1000
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [3000,3050)

[State -1, Onslaught AI]
type = ChangeState
value = 3000
triggerall = (roundstate = 2) && (var(58))
triggerall = random < 128
triggerall = statetype != A
triggerall = power >= 3000
trigger1 = ctrl
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA
trigger2 = stateno != [3000,3050)

;===========================================================================
[State -1, Combo condition Reset]
type = VarSet
trigger1 = 1
var(1) = 0

[State -1, Combo condition Check]
type = VarSet
trigger1 = statetype != A
trigger1 = ctrl
trigger2 = (stateno = [200,299]) || (stateno = [400,499])
trigger2 = stateno != 440 ;Except for sweep kick
trigger2 = movecontact
var(1) = 1

;==========================================================================
; AI Activation
[State -1, AI On]
type = VarSet
triggerall = RoundState = 2
trigger1 = command = "AI1"
trigger2 = command = "AI2"
trigger3 = command = "AI3"
trigger4 = command = "AI4"
trigger5 = command = "AI5"
trigger6 = command = "AI6"
trigger7 = command = "AI7"
trigger8 = command = "AI8"
trigger9 = command = "AI9"
trigger10 = command = "AI10"
trigger11 = command = "AI11"
trigger12 = command = "AI12"
trigger13 = command = "AI13"
trigger14 = command = "AI14"
trigger15 = command = "AI15"
trigger16 = command = "AI16"
trigger17 = command = "AI17"
trigger18 = command = "AI18"
trigger19 = command = "AI19"
trigger20 = command = "AI20"
trigger21 = command = "AI21"
trigger22 = command = "AI22"
trigger23 = command = "AI23"
trigger24 = command = "AI24"
trigger25 = command = "AI25"
trigger26 = command = "AI26"
trigger27 = command = "AI27"
trigger28 = command = "AI28"
trigger29 = command = "AI29"
trigger30 = command = "AI30"
var(58) = 1

[State -1, AI Off]
type = VarSet
triggerall = !Win
trigger1 = !alive
trigger2 = roundstate <= 1
trigger3 = roundstate >= 3
var(58) = 0

;===========================================================================
;---------------------------------------------------------------------------
;Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Run Back
[State -1, Run Back]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;===========================================================================
;Stand Light Punch
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = command = "x"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200
trigger2 = time > 46

[State -1, Stand Light Punch AI]
type = ChangeState
value = 200
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 20
triggerall = random < 53
triggerall = statetype != A
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA
trigger2 = time > 46

;---------------------------------------------------------------------------
;Stand Strong Punch
[State -1, Stand Strong Punch]
type = ChangeState
value = 210
triggerall = command = "y"
triggerall = command != "holddown"
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6

[State -1, Stand Strong Punch AI]
type = ChangeState
value = 210
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 44
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA
trigger2 = (stateno = 200) && time > 5
trigger3 = (stateno = 230) && time > 6

;---------------------------------------------------------------------------
;Taunt
[State -1, Taunt]
type = ChangeState
value = 195
triggerall = command = "start"
trigger1 = statetype != A
trigger1 = ctrl

;---------------------------------------------------------------------------
;Crouching Light Punch
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = command = "x"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger1 = statetime >= 15

[State -1, Crouching Light Punch AI]
type = ChangeState
value = 400
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 10
triggerall = statetype != A
trigger1 = ctrl
trigger1 = statetime >= 15
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA
trigger2 = time > 60
trigger2 = p2stateno = 400
trigger2 = p2stateno = 410
trigger2 = p2stateno = 430
trigger2 = p2stateno = 440
trigger2 = p2stateno = 6
trigger2 = p2stateno = 11

;---------------------------------------------------------------------------
;Crouching Strong Punch
[State -1, Crouching Strong Punch]
type = ChangeState
value = 410
triggerall = command = "y"
triggerall = command = "holddown"
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 28)

[State -1, Crouching Light Punch AI]
type = ChangeState
value = 410
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 10
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = (stateno = 400) || (stateno = 430)
trigger2 = (time > 28)
trigger2 = hitdefattr = SC, NA, SA
trigger2 = time > 60
trigger2 = p2stateno = 400
trigger2 = p2stateno = 410
trigger2 = p2stateno = 430
trigger2 = p2stateno = 440
trigger2 = p2stateno = 6
trigger2 = p2stateno = 11

;---------------------------------------------------------------------------
;Jump Light Punch
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "x"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600
trigger2 = statetime >= 27
trigger3 = stateno = 1350 ;Air blocking

[State -1, Jump Light PunchAI]
type = ChangeState
value = 600
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 41
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = hitdefattr = SC, NA, SA
trigger2 = stateno = 600
trigger2 = statetime >= 27
trigger3 = stateno = 1350

;---------------------------------------------------------------------------
;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = command = "y"
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;jump_x or jump_a
trigger2 = movecontact
trigger3 = stateno = 1350 ;Air blocking

[State -1, Jump Strong PunchAI]
type = ChangeState
value = 610
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < 84
triggerall = random < 42
triggerall = statetype != A
trigger1 = ctrl
trigger2 = movecontact
trigger2 = time > 58
trigger2 = hitdefattr = SC, NA, SA
trigger2 = stateno = 600 || stateno = 610
trigger3 = stateno = 1350

;---------------------------------------------------------------------------
;Marine Sword
[State -1, Marine Sword Helper]
type = ChangeState
value = 8800
triggerall = command = "Call Marine Sword"
triggerall = numhelper(25000) = 0
trigger1 = statetype != A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Marine Sword
[State -1, Marine Shotgun Helper]
type = ChangeState
value = 8801
triggerall = command = "Call Marine Shotgun"
triggerall = numhelper(15000) = 0
trigger1 = statetype != A
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Axe Hand Projectile (uses 1/3 of the bar)
[State -1, Axe Hand Projectile]
type = ChangeState
value = 215
triggerall = command = "Axe Hand Projectile"
triggerall = power >= 230
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = statetype != A
trigger2 = hitdefattr = SC, NA, SA, HA
trigger2 = stateno != [215,215)

[State -1, Axe Hand Projectile AI]
type = ChangeState
value = 1020
triggerall = (roundstate = 2) && (var(58))
triggerall = p2bodydist X < -24
triggerall = random < 24
triggerall = statetype != A
triggerall = power >= 230
trigger1 = ctrl
trigger2 = hitdefattr = SC, NA, SA
trigger2 = time > 24

;---------------------------------------------------------------------------
;Counter
[State -1, Counter]
type = ChangeState
value = 900
triggerall = power >= 10
triggerall = command = "Counter"
triggerall = statetype != A
trigger1 = !var(0)
trigger1 = stateno = 150
trigger2 = stateno = 151
trigger3 = stateno = 152
trigger4 = stateno = 153

[State -1, Counter AI]
type = ChangeState
triggerall = !win
triggerall = var(58) = 1
triggerall = power >= 10
triggerall = StateType = S
triggerall = p2movetype = A
triggerall = p2bodydist x <= 50
trigger1 = stateno = 150
trigger2 = stateno = 151
trigger3 = stateno = 152
trigger4 = stateno = 153
value = 900

